#define SCATTERING

float4 vExtInscMultipliers;
float4 vSunColorIntensity;
float4 vBetaRayleigh;
float4 vBetaDashRayleigh;
float4 vBetaMie;
float4 vBetaDashMie;
float4 vBetaRayleighMie;
float4 vOneOverBetaRM;
float4 vHG;
float4 vConstants;
float3 vFogColor	= float3(0.51f, 0.58f, 0.66f);
float2 FogStartEnd	= float2(0.0f, 2000.0);
float3 Blue = float3(0,0,1);
float3 Orange = float3(1,0.5f,0);

float4 Scattering(float3 vPos, float3 vEyePos, float3 vLightDir, float4 color)
{
	float3 vEyeVert = vEyePos - vPos; 
	float dist = length(vEyeVert.xyz);
	float Mask = clamp(dot(normalize(-1*vEyeVert),vLightDir), 0.0f, 1.0f);
        
        //debug sunny fog color
        //return float4(lerp(Blue,Orange,Mask),color.a); //ok
	
        float3 FogMixSunColor = lerp(vFogColor,vFogColor * float3(2.3f, 2.3f, 1.9f),Mask);
		
	float4 res = color;
	float fog = (FogStartEnd.y - dist)/(FogStartEnd.y - FogStartEnd.x);
	fog = saturate(fog);
	res.rgb = lerp(FogMixSunColor, res.rgb, fog);
	return res;

}
