#include "scattering.h"

float4x4	worldviewproj; 
float4x4	viewproj; 
float4x4	worldMatrix;
float4		lightDir;
float4		camPos;

float4		ambient;
float4		specular;
float		SpecularPower;

texture2D		diffuseTexture;
texture2D		specularTexture;


sampler2D diffuseMap = sampler_state
{
    Texture		= (diffuseTexture);
    AddressU	= WRAP;
    AddressV	= WRAP;       
	MinFilter	= LINEAR;
	MagFilter	= LINEAR;
	MipFilter	= LINEAR;
    MIPMAPLODBIAS	= 0.0f;
    MAXMIPLEVEL		= 0;
    MAXANISOTROPY	= 2.0f;
};

sampler2D specularMap = sampler_state
{
    Texture		= (specularTexture);
    AddressU	= WRAP;
    AddressV	= WRAP;       
	MinFilter	= LINEAR;
	MagFilter	= LINEAR;
	MipFilter	= LINEAR;
    MIPMAPLODBIAS	= 0.0f;
    MAXMIPLEVEL		= 0;
    MAXANISOTROPY	= 1;
};



struct VS_OUT
{
        float4	pos		:	POSITION;
	float2	uvDiff	:	TEXCOORD1;
        float4	vpos	:	TEXCOORD3;

};

VS_OUT VShader(
	float3	pos		:	POSITION	: register(v0),
	float2	uv0		:	TEXCOORD0	: register(v2)		//<- Diffuse 
	)
{
	VS_OUT Out	= (VS_OUT)0;
	Out.pos	= mul(float4(pos, 1), worldviewproj);	
	Out.uvDiff	= uv0;
	Out.vpos = mul(float4(pos, 1), worldMatrix);
	return Out;
}

VS_OUT VShaderInstanced(
	float3	pos		:	POSITION	: register(v0),
	float2	uv0		:	TEXCOORD0	: register(v2),		//<- Diffuse 
	float4 row1			: TEXCOORD2	: register(v4),
	float4 row2			: TEXCOORD3	: register(v5),
	float4 row3			: TEXCOORD4	: register(v6),
	float4 row4			: TEXCOORD5	: register(v7))
{
	VS_OUT Out	= (VS_OUT)0;
	
	float4x4 mWorld = float4x4(row1, row2, row3, row4);
	Out.vpos = mul(mWorld, float4(pos, 1));
	Out.pos = mul(Out.vpos, viewproj);
	Out.uvDiff	= uv0;
	return Out;
}

float4 PShader(
	float2	uvDiff	:	TEXCOORD1	: register(v1),
	float4	vpos	:	TEXCOORD3	: register(v3)
	) : COLOR
{	
	float4 color			= tex2D(diffuseMap,	uvDiff.xy);
	color = Scattering(vpos.xyz, camPos.xyz, lightDir.xyz, color);
        return color;
}


technique Default
{
    pass Pass0
    {    
		FillMode = SOLID;
		Lighting = FALSE;
		Clipping = FALSE;
		CullMode = NONE;
		
		FogEnable	= FALSE;
		FogColor	= 0x00000000;
		FogDensity	= 1.0f;
		FogEnd		= 10000.0f;
		FogStart	= 50.0f;
				
		//Pixel Pipe Render States
		AlphaBlendEnable	= FALSE;
		AlphaRef			= 0x50;
		AlphaTestEnable		= FALSE;
		AlphaFunc			= GREATER;	
					
		ZEnable				= TRUE;
		ZWriteEnable		= TRUE;
		ZFunc				= LESSEQUAL;

		SrcBlend			= SRCALPHA;
		DestBlend			= INVSRCALPHA;
		
		VertexShader = compile vs_2_0 VShader();
		PixelShader  = compile ps_2_0 PShader();	
    }
}

technique Transparent
{
    

	pass Pass0
    {    
		FillMode	= SOLID;

		Lighting	= FALSE;
		Clipping	= FALSE;
		CullMode	= NONE;

		FogEnable	= FALSE;
		FogColor	= 0x00000000;
		FogDensity	= 1.0f;
		FogEnd		= 10000.0f;
		FogStart	= 50.0f;

		AlphaBlendEnable	= FALSE;
		AlphaRef			= 200;
		AlphaTestEnable		= TRUE;		
		AlphaFunc			= GREATEREQUAL;	

		ZEnable				= TRUE;
		ZWriteEnable		= TRUE;
		ZFunc				= LESSEQUAL;

		SrcBlend			= SRCALPHA;
		DestBlend			= INVSRCALPHA;  

		VertexShader = compile vs_2_0 VShader();
		PixelShader  = compile ps_2_0 PShader();
    }   
}

technique DefaultInstanced
{
    pass Pass0
    {    
		FillMode = SOLID;
		Lighting = FALSE;
		Clipping = FALSE;
		CullMode = NONE;
		
		FogEnable	= FALSE;
		FogColor	= 0x00000000;
		FogDensity	= 1.0f;
		FogEnd		= 10000.0f;
		FogStart	= 50.0f;
				
		//Pixel Pipe Render States
		AlphaBlendEnable	= FALSE;
		AlphaRef			= 0x50;
		AlphaTestEnable		= FALSE;
		AlphaFunc			= GREATER;	
					
		ZEnable				= TRUE;
		ZWriteEnable		= TRUE;
		ZFunc				= LESSEQUAL;

		SrcBlend			= SRCALPHA;
		DestBlend			= INVSRCALPHA;
		
		VertexShader = compile vs_2_0 VShaderInstanced();
		PixelShader  = compile ps_2_0 PShader();	
    }
}

technique TransparentInstanced
{
    
	pass Pass0
    {    
		FillMode	= SOLID;

		Lighting	= FALSE;
		Clipping	= FALSE;
		CullMode	= NONE;

		FogEnable	= FALSE;
		FogColor	= 0x00000000;
		FogDensity	= 1.0f;
		FogEnd		= 10000.0f;
		FogStart	= 50.0f;

		AlphaBlendEnable	= FALSE;
		AlphaRef			= 200;
		AlphaTestEnable		= TRUE;		
		AlphaFunc			= GREATEREQUAL;	

		ZEnable				= TRUE;
		ZWriteEnable		= TRUE;
		ZFunc				= LESSEQUAL;

		SrcBlend			= SRCALPHA;
		DestBlend			= INVSRCALPHA;  

		VertexShader = compile vs_2_0 VShaderInstanced();
		PixelShader  = compile ps_2_0 PShader();
    }   
}
