//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------

float3   lightDir;              
float4x4 world;
float4x4 viewproj; 





void VertShadowVolume( float4 vPos		: POSITION,
                       float3 vNormal	: NORMAL,
                       out float4 oPos	: POSITION )
{

    float3 N		= mul(vNormal, (float3x3)world);
	float4 Pos		= mul(float4(vPos.xyz, 1), world);
	float3 L		= lightDir;

    if( dot( N, -L) < 0.0f )
    {
		Pos.xyz -= L * 5.0;       
    } 
	oPos = mul(Pos, viewproj);
}


float4 PixShadowVolume() : COLOR0
{
	return float4(0,0,0,1.0);
}

float4 red() : COLOR0
{
	return float4(1,0,0,1.0);
}

float4 blue() : COLOR0
{
	return float4(0,0,1,1.0);
}


technique RenderShadowVolume
{
    pass P0
    {
        VertexShader = compile vs_2_0 VertShadowVolume();
        PixelShader  = compile ps_2_0 PixShadowVolume();
        CullMode			= Ccw;
        // Disable writing to the frame buffer
        AlphaBlendEnable	= true;
        SrcBlend			= Zero;
        DestBlend			= One;
        // Disable writing to depth buffer
        ZWriteEnable		= false;
        ZFunc				= Less;
        // Setup stencil states
        StencilEnable		= true;
        StencilRef			= 1;
        StencilMask			= 0xFFFFFFFF;
        StencilWriteMask	= 0xFFFFFFFF;
        StencilFunc			= Always;
        StencilZFail		= Decr;
        StencilPass			= Keep;
		ColorWriteEnable	= 0x0;
		ZEnable				= true;
    }


    pass P1
    {
        VertexShader		= compile vs_2_0 VertShadowVolume();
        PixelShader			= compile ps_2_0 PixShadowVolume();
        CullMode			= Cw;
        StencilZFail		= Incr;
		ColorWriteEnable	= 0x0;
		ZEnable				= true;
    }


/*
	pass P2
    {
		FillMode = solid;
        VertexShader = compile vs_2_0 VertShadowVolume();
        PixelShader  = compile ps_2_0 red();

		ColorWriteEnable	= 0x1;
		AlphaTestEnable		= FALSE;
		AlphaBlendEnable	= false;
		SrcBlend			= SRCALPHA;
        DestBlend			= INVSRCALPHA;
		CullMode			= None;
		ZEnable				= TRUE;
		ZWriteEnable		= false;
		ZFunc				= lessEQUAL;
		StencilEnable		= false;
    }

	pass P3
    {
		FillMode = wireframe;
        VertexShader = compile vs_2_0 VertShadowVolume();
        PixelShader  = compile ps_2_0 blue();

		ColorWriteEnable	= 0x1;
		AlphaTestEnable		= FALSE;
		AlphaBlendEnable	= false;
		SrcBlend			= SRCALPHA;
        DestBlend			= INVSRCALPHA;
		CullMode			= None;
		ZEnable				= TRUE;
		ZWriteEnable		= false;
		ZFunc				= lessEQUAL;
		StencilEnable		= false;
    }
*/
}


float4 StencilPS(in float2 vScreenPosition : TEXCOORD0) : COLOR
{
	return float4(0,0,0,0.4);
}
technique Stencil
{
    pass P0
    {
        ZEnable = false;
        StencilEnable = true;
        AlphaBlendEnable = true;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        StencilRef = 0;
        StencilFunc = Less;
        StencilPass = Keep;

        PixelShader  = compile ps_2_0 StencilPS();
    }	
}








