# Introduction
This document contains information how to setup a live gauge for a car in RBR.
It is written in markdown, I recommend using something like https://github.com/marktext/marktext or copying this into some mark editor online for easier reading.
This part of the plugin allows for dynamic drawing on the ingame texture to add gauges to the cars. Not all cars are fully supported or will end up with a good result due to the way that their model is done.
But hopefully all cars can be supported over time.

# Setting up
1. First you will need to create a folder in /plugins/rbrhud/customgauges/ name it after your car. For example Favorit for Skoda Favorit. It should be the same as the car foldres in `RBRDIR\cars\`.
`customgauges` is for your custom gauges and has priority over `gauges` folder. `gauges` folder is meant for releases via RSF plugin.
2. In the folder you will need to create a config.ini file. To start off you should have a replacement texture for the original texture the game uses. This texture will be used in place of the original when the plugin is active.
3. You should start with something like this:
`````markdown
; Skoda Favorit Stock texture, configuration by Towerbrah
[Main]
Texture=Favorit_internal.dds
Author=Towerbrah
`````
`Favorit_internal.dds` - file should be in the same directory as the `config.ini` file. This is the same filename of the file that is gonna be replaces in `RBRDIR\cars\favorite\textures\` folder
5. Now if you have configured everything correctly when going into the game you should see your new texture being applied to the car.

# General Tips:
- For the main texture use `BC3 DXT5` format with `NO MIP MAPS`(mip maps are useless)
- For small textures should .png as this saves space
- Gauge needles should point west for easier use/reuse/etc. <-------O- 
- If you enable `Debug` flag in `gauges.ini` you can use `Home` button to hot reload your `config.ini` changes
- Order in the list matters, you should put dirtyregions first and then put everything from bottom to the top(in terms of depth if you want to get some objects to be covered by others)
- Section names in the config file must be all unique:
[Main]
[DirtyRegion1]
[DirtyRegion2]
[RPM1]
[RPM2]
Sections with repeating names **will not work!**
- If you need to have rendering for a second texture you can create `config2.ini` and it will be used to render onto the second specified texture. Same logic for the file applies.

# Configuring gauges
This is a general workflow on how to approach making a gauge for the car.

- Setup your dirty region/regions first - they should cover the areas where you will be drawing as tightly as possible.
- Work on your texture in your image editor. I will provide instructions for GIMP. 
- When your base texture looks good( It should be fairly clean, no gauges, numbers etc. ). You should start making assets for it.
- I recommend making the assets in their own separate layers and make sure these asset layers are as small as possible. Use `Layer->Crop to selection` if needed.
- Export the base texture layer as dds file using `BC3|DXT5` format and for Mip Maps `No Mipmaps` selected save it with approprate name in your `/plugins/rbrhud/gauges/-your-car-/` folder.
- For exporting your other layers I highly recommend using this: https://github.com/kamilburda/gimp-export-layers this will make it a lot easier being able to batch export all your assets.
- Once you are done with you can proceed configuring your `config.ini` file, I highly recommnd to use `Home` key to hotreload your changes, this includes texture changes as well. See: **General Tips**.
- Configuring `config.ini` requires you to setup sections with their specific purpose. Section name [Name] does not matter but it should be unique. The type is determing by the sections `Type=` value.
- Use various types to setup objects for your needs. You can find these Section types below.

# Section Types `Type=`

## DirtyRegion `Type=DirtyRegion`
This type is used for optimization, if this is not configured the whole texture gets cleared every update, which is not optimal performance wise. You should set up dirty regions where you do any drawing, so that the texture is clean for the next update.
### Values:
- Left - x coordinate for the `left` side of the rectangle that will get cleared
- Top - y coordinate for the `top` side of the rectangle that will get cleared
- Right - x coordinate for the `right` side of the rectangle that will get cleared
- Bottom - y coordinate for the `bottom` side of the rectangle that will get cleared

V(Left, Top)(x,y)
|---------------------|
|---------------------|
|---------------------|
|---------------------|
|---------------------|
|---------------------|
------------------------^(Right, Bottom)(x,y)

Example:
`````markdown
[DirtyRegion1]
Type=DirtyRegion
Left=1410
Top=495
Right=2034
Bottom=735
`````

## Static `Type=Static`
This type of object can be used if you need to obscure something partially or you need to make sure some things don't disappear when you draw over them.
### Values:
- xPos
- yPos
- Texture - what texture will be used. (PNG file)
### Optional Values:
- Colour - set color this object. `Colour=FF00FF00` ARGB format
- Effect - associate effect with this object this value is section name of the effect. Check below for how to use effects.

Example:
`````markdown
[Labels]
Type=Static
xPos=1976
yPos=137
Texture=Labels.png
`````

## Gears `Type=Gears`
This object type should be used for displayed the current gear. They all should be the same size for alignment purposes.

### Values:
- xPos
- yPos
GearR - Texture for Reverse. (PNG file)
GearN - Texture for N. (PNG file)
Gear1 - Texture for 1. (PNG file)
Gear2 - Texture for 2. (PNG file)
Gear3 - Texture for 3. (PNG file)
Gear4 - Texture for 4. (PNG file)
Gear5 - Texture for 5. (PNG file)
Gear6 - Texture for 6. (PNG file)

Example:
`````markdown
[Gears]
Type=Gears
xPos=3847
yPos=2638
GearR=Gears\GearR.png
GearN=Gears\GearN.png
Gear1=Gears\Gear1.png
Gear2=Gears\Gear2.png
Gear3=Gears\Gear3.png
Gear4=Gears\Gear4.png
Gear5=Gears\Gear5.png
Gear6=Gears\Gear6.png 
`````
In this example the textures are put it into their own folder `Gears\` for easier organizing.

## Simple `Type=Simple`
This used for these effects where you see the object increase in size. i20_rally2 uses this effect for the rev lights(green and yellow)
### Values:
- xPos
- yPos
- Texture - what texture will be used.
- Data - one of the Car Data Types (Threshold, Boolean or Warning data)
### Optional Values:
- Colour - set color this object. `Colour=FF00FF00` ARGB format
- Effect - associate effect with this object this value is section name of the effect. Check below for how to use effects.

Example (shift light):
`````markdown
[RedShift]
Type=Simple
Data=UpShift
Threshold=-200
xPos=1756
yPos=0
Texture=ShiftLightRed.png
`````

## Expanding `Type=Expanding`
This object is used for special effects like RPM bar, Rev Light bar, digital temperature gauge
### Values:
- xPos
- yPos
- Texture - what texture will be used. (PNG file)
- Data - one of the Car Data Types (Float data)
- ExpandStartValue - at what Data value this texture should be at 0% size
- ExpandEndValue - at what Data value this texture should be at 100% size
- Direction - Up, Down, Left, Right determines which way the texture expands
### Optional Values:
- Colour - set color this object. `Colour=FF00FF00` ARGB format
- Effect - associate effect with this object this value is section name of the effect. Check below for how to use effects.
Example:

`````markdown
[YellowShift1]
Type=Expanding
Direction=Up
Data=UpShift
ExpandStartValue=-600
ExpandEndValue=-200
xPos=1701
yPos=0
Texture=ShiftLightYellow.png
`````

## Rotating `Type=Rotating`
This object is used for rotating needles like typical car RPM gauge speed gauge and etc.
### Values:
- xPos
- yPos
- Texture - what texture will be used. (PNG file)
- Data - one of the Car Data Types (Float data)
- xPivot - where in the `Texture=` file the rotation center is also where this texture will attach to the main texture `xPos`
- yPivot -  where in the `Texture=` file the rotation center is also where this texture will attach to the main texture `yPos`
### Linear Rotation Mapping:
- RotationStartDeg - Denotes how much rotation should be applied to the needle at the start depends on the gauge texture (this value will be negative in most cases)
- RotationStartValue - Denotes the starting value, for RPM this is usually 0
- RotationEndDeg - Denotes at how many degrees the rotation ends, this depends on the gauge texture, examples: 180,200,220 etc.
- RotationEndValue=240 - Denotes the ending value, match this to the texture, for example if the last value reads 8000, set this to 8000
### Non Linea rRotation Mapping
This should have logical values all increasing or all decreasing(and rotating in same direction), no idea what happens when you put random stuff here.
- Rotation0Deg - First rotation point degrees same as `RotationStartDeg`
- Rotation0Value - First point value same as `RotationStartValue`
- Rotation1Deg - Second rotation point degrees same as `RotationEndDeg`
- Rotation1Value - Second point value same as `RotationEndValue`
- Rotation2Deg - Third rotation point degrees
- Rotation2Value - Third point value same as
...
Can have as many as needed of these
### Optional values:

- Digital - if set to 1 this ignores all needle movement calculations. Default=0

- DampingRatio - How much damping apply to the needle movement, default=2(lower to increase needle wobbliness). Don't set it to 0
- SpringConstant - how springy the needly is, think of it is attractiveness to the correct position, default=30
- RotationSpeed - this is how fast the needle should rotate in degrees per sec. Default value is good for most cases. Maybe increase for digital screens. (default=10)
Defaults for these needles are fairly weel balanced, for older cars you can set `DampingRatio=1.5` to increase the needle play a bit.

Example linear:
`````markdown
[Speedo]
Type=Rotating
Data=SpeedKPH
xPos=615
yPos=1990
Texture=NeedleLong.png
xPivot=174
yPivot=27
RotationStartDeg=-38
RotationStartValue=5
RotationEndDeg=200
RotationEndValue=240
`````

Example non-linear:
`````markdown
[RPM]
Type=Rotating
Data=RPM
xPos=128
yPos=128
Texture=Dynamic\NeedleRPM.png
xPivot=114
yPivot=5
Rotation0Deg=-130
Rotation0Value=0
Rotation1Deg=-90
Rotation1Value=4000
Rotation2Deg=130
Rotation2Value=9400
`````
Here from 0 to 4000 rpm we rotate around 40 degrees, but from 4000 to 9400 we rotate 220 degrees

## Pie `Type=Pie`
This can be used for these round speedo/rpm displays that dont use needles kinda like pretty much any racing game.
Default rotation when using 0 to 360 is clockwise, use 0 to -360 to do counter clockwise.
### Values:
- xPos
- yPos
- Texture - what texture will be used. (PNG file)
- Data - one of the Car Data Types (Float data)
### Linear Rotation Mapping:
- RotationStartDeg - at what degrees the pie slice starts. 0 = pointing south, 90 = pointing west.
- RotationStartValue - Denotes the starting value, for RPM this is usually 0
- RotationEndDeg - at what degrees the pie slice ends.
- RotationEndValue=240 - Denotes the ending value, match this to the texture, for example if the last value reads 8000, set this to 8000
### Non Linea rRotation Mapping
This should have logical values all increasing or all decreasing(and rotating in same direction), no idea what happens when you put random stuff here.
- Rotation0Deg - First rotation point degrees same as `RotationStartDeg`
- Rotation0Value - First point value same as `RotationStartValue`
- Rotation1Deg - Second rotation point degrees same as `RotationEndDeg`
- Rotation1Value - Second point value same as `RotationEndValue`
- Rotation2Deg - Third rotation point degrees
- Rotation2Value - Third point value same as
...
Can have as many as needed of these
### Optional values:
- Colour - set color this object. `Colour=FF00FF00` ARGB format
- Effect - associate effect with this object this value is section name of the effect. Check below for how to use effects.

Example clockwise:
`````markdown
[RPMHUD]
Type=Pie
Data=RPM
Rotation0Deg=0
Rotation0Value=0
Rotation1Deg=180
Rotation1Value=1000
Rotation2Deg=720
Rotation2Value=7500
xPos=1756
yPos=100
Texture=ShiftLightRed.png
`````

Example counter clockwise(angle decreases):
`````markdown
[RPMHUD]
Type=Pie
Data=RPM
Rotation0Deg=0
Rotation0Value=0
Rotation1Deg=-180
Rotation1Value=1000
Rotation2Deg=-720
Rotation2Value=7500
xPos=1756
yPos=100
Texture=ShiftLightRed.png
`````

## Number `Type=Number`
This used for drawing numbers. Like RPM numbers for example: 7512, 1234, etc.
Texture requires these characters to be in this particular order: `0123456789:.-`
Each symbol must occupy the same amount of space. Monospace fonts are the easiest to use as they can be exported very easily using GIMP.
### Values:
- xPos
- yPos
- Font - what font texture will be used. (PNG file)
- Data - one of the Car Data Types (Float data)
- Format - determines how the text should be displayed. Look at **Number Format Types** below.
### Optional values:
- Rotation - Text direction in degrees 0 to 360. Clockwise rotation. Default = 0.0 
- Colour - set color this object. `Colour=FF00FF00` ARGB format
- Effect - associate effect with this object this value is section name of the effect. Check below for how to use effects.
- NumberJustification - xPos, yPos is the origin. Allowed values `Left`, `Right`, `Center`. Default = `Left`
Example KPH display:
`````markdown
[SpeedNumber]
Type=Number
xPos=1914
yPos=169
Data=SpeedKPH
Format=Whole
Font=i20font.png
`````

## Colour `Type=Colour`
This objects allow for colour transitions for the object, Can be used for things like shift lights. It linearly interpolates between the two colours based on the set values and colours.
### Values:
- xPos
- yPos
- Texture - what texture will be used. (PNG file)
- Data - one of the Car Data Types (Float data)
- ColourStartValue - Value at which ColourStart will be shown, hidden below this value.
- ColourEndValue - Value at which ColourEnd will be shown
- ColourStart - Colour which will be shown at the start value (ARGB format) 
- ColourEnd - Colour which will be shown at the end value (ARGB format)
Some color examples: `FFFFFFFF` for White, `FFFF0000` - Red, `FF00FF00` - Green, `FF000000` - Black)
### Optional values:
- Effect - associate effect with this object this value is section name of the effect. Check below for how to use effects.

Example:
This will go From Green to Red when the UpShift point gets closer.
`````markdown
[RedShift]
Type=Colour
Data=UpShift
xPos=1497
yPos=300
ColourStartValue=-1400
ColourStart=CC00FF00
ColourEndValue=0
ColourEnd=CCDD0000
Texture=Gears\GearBackground.png
`````
## Effect `Type=Effect`
This object type is meant to modify how other objects are displayed. Adding effects like blink, colour change etc.
**EFFECT SHOULD BE DECLARED BEFORE ITS USAGE**
**WHEN USING THE EFFECT YOU LINK IT TO THE OBJECT VIA SECTION NAME** 
```
[SomeEffectSectionName]
...
[SomeObject]
Effect=SomeEffectSectionName
```
### Values:
- EffectType - Valid types: `Blink`, `ColourChange`, `OnlyFirst`. Can be combined: `EffectType=Blink|ColourChange`
- Data - what data to use (not required for onlyfirst type)
### Optional Values:
- Threshold - For threshold data types, explained below.
- BlinkSpeed - in ms to be used with `Blink`. Default=250ms;
- NewColour - To be used with colour change. `Default=FFFFFFFF` - no change. ARGB format.
### EffectType explanation:
- Blink - when the Data values passes the threshold the object will blink using the BlinkSpeed as interval. 250ms - 125ms on, 125ms off.
- ColourChange - When the value passes a certain threshold. New colour will be applied to the object.
- OnlyFirst - Only the first object that is associated with the effect will be shown.

Example:
`````markdown
[EffectRedShift]
Type=Effect
EffectType=Blink|ColourChange
Data=UpShift
Threshold=0
BlinkSpeed=150
newcolour=FFFF0000

[RedShift]
Type=Simple
Data=UpShift
Threshold=-200
xPos=1756
yPos=0
Texture=ShiftLightRed.png
Effect=EffectRedShift

[YellowShift1]
Type=Expanding
Direction=Up
Data=UpShift
ExpandStartValue=-600
ExpandEndValue=-200
xPos=1701
yPos=0
Texture=ShiftLightYellow.png
Effect=EffectRedShift

[GreenShift1]
Type=Expanding
Direction=Up
Data=UpShift
ExpandStartValue=-1000
ExpandEndValue=-600
xPos=1646
yPos=0
Texture=ShiftLightGreen.png
Effect=EffectRedShift
`````
This makes it so when Data threshold is reached all of these objects only show red and blink.
# Car Data Types `Data=`

## Float Data:

- CoolantTemperatureC - Starts at around 79 and goes up to 140 when there's damage to the cooling system or overheating.
- RadiatorCoolantTemperatureC - This one changes a lot more depending on the speed and other factors.
- RPMPercent - Range from 0 to 100.
- RPM - 0 to ~9000 (depends on the car).
- SpeedKPH - 0 to 280 (max speed is uncertain). This is speed measured by some wheel, I guess frontleft.
- GroundSpeed - 0 to 280? Can think of this as GPS speed.
- WheelSlip - 0.0 to 1.0. This is how much your tires spin against the tarmac. 0.0 being perfect grip.
- WheelLock - 0.0 to 1.0. This is how much your wheels lock against the tarmac. 0.0 no lock at all.
- OilTemperatureC - Approximately 20 degrees hotter than coolant and changes more dynamically.
- OilPressurePsi - 0 - 70 (depends on the car; 55-60 seems normal).
- OilPressureBar - Equivalent to `OilPressurePsi` but in Bar.
- RaceTime - Includes penalties; ranges from 0.0 to infinity-ish.
- RaceTimeMinutes - 0.0 to 59.99.
- RaceTimeSeconds - 0.0 to 59.99.
- DistanceFromStart - Measured from start. (km)
- DistanceTravelled - Total distance traveled. (km)
- DistanceToFinish - As seen on [digidash]. (km)
- DistanceFromStartMeters - Measured from start in meters.
- DistanceTravelledMeters - Total distance traveled in meters.
- DistanceToFinishMeters - Remaining distance to finish in meters.
- DistanceDriven - Recommended for distance driven; should match [digidash]. (km)
- DistanceDrivenMeters - Distance driven in meters.
- TurboPressureBar - Ranges from 0.0 up to around 2.6 or possibly higher; 0.0 on NA cars.
- TurboPressurePsi - Equivalent to `TurboPressureBar` but in Psi.
- BatteryVoltage - Ranges from around 11 to 14.5 depending on the battery condition and if the car is running.
- SystemTime - Expected to range from 0-86400.
- SystemTimeHours - Expected to range from 0.0-23.99.
- SystemTimeMinutes - Expected to range from 0.0-59.99.
- SystemTimeSeconds - Expected to range from 0.0-59.99.
- InputThrottle - Ranges from 0.0 to 1.0.
- InputBrake - Ranges from 0.0 to 1.0.
- InputClutch - Ranges from 0.0 to 1.0.
- InputHandbrake - Ranges from 0.0 to 1.0.
- InputSteering - Ranges from -1.0 to 1.0.
- UpShift - Perfect time to upshift. Does not exist for max gear, N and R.
- DownShift - Perfect time to downshift when in a too low RPM range for the current gear. Does not exist for max gear, N and R.

## Threshold data (Simple Type):

`Threshold=` should be specified for these data types otherwise `Threshold=0` will be used. For example `Threshold=-200` will show upshift 200 rpm earlier and etc.

- UpShift
- DownShift
- RPM
- RPMPercent
- TurboPressureBar
- TurboPressurePsi
- WheelLock
- WheelSlip

## Boolean Data (Simple Type Only):

- EngineOn - Indicates if the engine is on.
- EngineOff - Indicates if the engine is off.
- HandbrakeON - Indicates if the handbrake is engaged.

## Warning Data (Simple Type Only):

- OilPressureWarning - Activates when oil pressure drops under 80% of its value.
- OilTemperatureWarning - Activates when temperature exceeds 140 degrees.
- CoolantTemperatureWarning - Activates when temperature exceeds 120 degrees.
- BatteryLevelWarning - Activates when battery capacity drops under 80% of its value.

# Number Format Types `Format=` :

- Whole - Represents whole numbers (e.g., `1`).
- Padded2 - Two-digit padding (e.g.,   `01`).
- Padded3 - Three-digit padding (e.g., `001`).
- Padded4 - Four-digit padding (e.g.,  `0001`).
- Decimal2 - Displays up to two decimal places (e.g., `1.23`).
- Decimal1 - Displays up to one decimal place (e.g., `1.2`).
- TimeMinSecMs - Time format with minutes, seconds, and milliseconds (e.g., `00:01.23`).
- TimeMinSecMsc - Time format with minutes, seconds, and three-digit milliseconds (e.g., `00:01.234`).
- TimeMinSec - Time format with just minutes and seconds (e.g., `00:01`).
- TimeHoursMin - Time format HH:MM (e.g., `23:23`).
- TimeHoursMinSec - Time format HH:MM:SS (e.g., `23:58:58`).

**Written by: Towerbrah (c)**