float4x4 C0 : register(c0);
float4x4 C8	: register(c8);
float4x4 C20: register(c20);

float4 C41;
float4 C50;
float4 C55	: register(c55);
float4 C59	: register(c59);

float4 C60	: register(c60);
float4 C61	: register(c61);
float4 C62	: register(c62);
float4 C63	: register(c63);

float4 C64	: register(c64);
float4 C65	: register(c65);
float4 C66	: register(c66);



/*
SunDir = -0.843359 -0.503774 0.186968
pConstants[41]	{0.853474, 0.485573, -0.189211, 1}	D3DXVECTOR4
*/


 
struct VSOutput
{
	float4 position : POSITION;
	float4 diffuse	: TEXCOORD0;
	float3 vPos		: TEXCOORD1;
	float3 sDir		: TEXCOORD2;
	float4 sCol		: TEXCOORD3;
	float3 vDir		: TEXCOORD4;

};
 


VSOutput VS(	float3 position : POSITION	: register(v0),
				float3 normal	: NORMAL	: register(v1))
{
	VSOutput OUT = (VSOutput)0;

	OUT.position = mul(C0, float4(position.xyz, 1));

	float4 R10	= mul(C8, float4(position.xyz, 1));

OUT.vPos	= R10.xyz;


	float3 vertexDir = normalize(C50 - R10);
	float3 SunDir = C41.xyz;

OUT.sDir = SunDir;
OUT.vDir = vertexDir;

	float sunVertAngle = dot(SunDir.xyz, vertexDir);

	sunVertAngle = min(sunVertAngle, 0);
	float sunVertAngleShift  = sunVertAngle * sunVertAngle + 1;

	float4 R1B = mul(C20, R10);

	float Skybox_Scale = C66.x;

	float dist = R1B.z * Skybox_Scale;

	R1B = C61 * (- dist);
	R1B = R1B * C64.y;
	R1B = pow(2, R1B);

	float4 R4;
	R4.x = C63.z * sunVertAngle + C63.y;
	R4.x = 1.0/sqrt(R4.x);
	R4.x = R4.x * R4.x * R4.x;

	float beta = R4.x * C63.x;

	float4 R5;
	float4 R6;
	float4 R7;

	R4 = C59 * sunVertAngleShift;
	R5 = C60 * beta;
	R6 = float4(C64.x, C64.x, C64.x, C64.x) - R1B;
	R7 = C61;

	R4 = R4 + R5;
	R4 = R4 * R6;
	R4 = R4 * C62;
	R4 = R4 * C65.y;

	OUT.sCol = C55;

	OUT.diffuse.xyz = float4(R4.xyz, 1);

	return OUT;
}


float4 PS(	float4 diffuse	: TEXCOORD0	: register(v0),
			float3 vPos		: TEXCOORD1	: register(v1),
			float3 sDir		: TEXCOORD2	: register(v2),
			float4 sCol		: TEXCOORD3	: register(v3),
			float3 vDir		: TEXCOORD4	: register(v4)
			) : COLOR
{
	float4 color = float4(1,1,1,1);

	//color.xyz = diffuse.xyz * sCol.xyz;
	//color.xyz = saturate(color.xyz);

	float3 vertexDir = normalize(C50 - vPos);
	float hazeA = 1 - abs(dot(vertexDir, float3(0,-1,0)));

	hazeA = pow(hazeA, 2); //day

	float3 hazeColor	= float3(0.7,0.9,1);
	float3 skyColor		= float3(0.3,0.6,1);

	color.xyz = skyColor * (1 - hazeA)  + hazeColor * hazeA;

	color.xyz = saturate(color.xyz);

	float sunPower =  dot(normalize(float3(vertexDir.x, 0, vertexDir.z)), -normalize(float3(C41.x, 0, C41.z)));

	sunPower *= sunPower;

	float k = dot(C41.xyz, -vertexDir.xyz);
	k = max(0, k);
	k = pow(k, 512); //day

	if(k > 0.95)
	{
		k = 1;
	}

	float3 sun = float3(sunPower*1, sunPower*0.9, sunPower*0.75)*1.2; 
	color.xyz = saturate(k * sun + color.xyz * (1 - k));
	color.w = 1;
	return color;
}
 
technique FogTechnique
{
	pass p1
	{
		FillMode = SOLID;

		Lighting = FALSE;
		Clipping = FALSE;
		CullMode = NONE;
		
		FogEnable	= FALSE;
		FogColor	= 0x00000000;
		FogDensity	= 1.0f;
		FogEnd		= 10000.0f;
		FogStart	= 50.0f;

		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_2_0 PS();
	}


}